% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data0.R
\name{prep_data_nestedsymmetric}
\alias{prep_data_nestedsymmetric}
\title{Prepare data for evaluation in nested symmetric double-factor experiments}
\usage{
prep_data_nestedsymmetric(
  data,
  type = "counts",
  Sest.method = "average",
  cases = 5,
  N = 100,
  sites = 10,
  n,
  m,
  k = 50,
  transformation = "none",
  method = "bray",
  dummy = FALSE,
  useParallel = TRUE
)
}
\arguments{
\item{data}{Data frame with species names (columns) and samples (rows)
information. The first column should indicate the site to which the sample
belongs, regardless of whether a single site has been sampled.}

\item{type}{Nature of the data to be processed. It may be presence / absence
("P/A"), counts of individuals ("counts"), or coverage ("cover")}

\item{Sest.method}{Method for estimating species richness. The function
specpool is used for this. Available methods are the incidence-based Chao
"chao", first order jackknife "jack1", second order jackknife "jack2" and
Bootstrap "boot". By default, the "average" of the four estimates is used.}

\item{cases}{Number of data sets to be simulated.}

\item{N}{Total number of samples to be simulated in each site.}

\item{sites}{Total number of sites to be simulated in each data set.}

\item{n}{Maximum number of samples to consider.}

\item{m}{Maximum number of sites.}

\item{k}{Number of resamples the process will take. Defaults to 50.}

\item{transformation}{Mathematical function to reduce the weight of very
dominant species: 'square root', 'fourth root', 'Log (X+1)', 'P/A', 'none'}

\item{method}{The appropriate distance/dissimilarity metric (e.g. Gower,
Bray–Curtis, Jaccard, etc). The function \code{\link[vegan:vegdist]{vegan::vegdist()}} is called for
that purpose.}

\item{dummy}{Logical. It is recommended to use TRUE in cases where there are
observations that are empty.}

\item{useParallel}{Logical. Perform the analysis in parallel? Defaults to FALSE.}
}
\value{
\code{prep_data()} returns an object of class "ecocbo_data".

An object of class "ecocbo_data" is a list containing: \code{$Results}, a data
frame that lists the estimates of pseudoF for \code{simH0} and \code{simHa}
that can be used to compute the statistical power for different sampling
efforts, as well as the square means necessary for calculating the variation
components.
}
\description{
\code{prep_data()} formats and arranges the initial data so that it can be
readily used by the other functions in the package. The function first gets
the species names and the number of samples for each species from the input
data frame. Then, it permutes the sampling efforts and calculates the pseudo-F
statistic and the mean squares for each permutation. Finally, it returns a
data frame with the permutations, pseudo-F statistic, and mean squares.
}
\references{
Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.

Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
\seealso{
\code{\link[=prep_data]{prep_data()}}
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=plot_power]{plot_power()}}
\code{\link[=sim_cbo]{sim_cbo()}}
\code{\link[=scompvar]{scompvar()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
\keyword{internal}
