% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projections.R
\name{projections}
\alias{projections}
\title{Country-product bipartite network projections}
\usage{
projections(proximity_c, proximity_p, cutoff_c = 0.2, cutoff_p = 0.4,
  compute = "both", tbl = TRUE, from_c = "from", to_c = "to",
  value_c = "value", from_p = "from", to_p = "to",
  value_p = "value")
}
\arguments{
\item{proximity_c}{matrix or data frame with product proximity values}

\item{proximity_p}{matrix or data frame with country proximity values}

\item{cutoff_c}{all the links with a proximity below this value will be
removed from the country projection (by default is 0.2)}

\item{cutoff_p}{all the links with a proximity below this value will be
removed from the product projection (by default is 0.4)}

\item{compute}{"country", "product" or "both" (default) projections}

\item{tbl}{TRUE (default) returns a data.frame and FALSE returns a matrix}

\item{from_c}{column containing origin (applies only if proximity_c is a
data.frame)}

\item{to_c}{column containing destination (applies only if proximity_c is a
data.frame)}

\item{value_c}{column containing proximity values (applies only if
proximity_c is a data.frame)}

\item{from_p}{column containing origin (applies only if proximity_p is a
data.frame)}

\item{to_p}{column containing destination (applies only if proximity_p is a
data.frame)}

\item{value_p}{column containing proximity values (applies only if
proximity_p is a data.frame)}
}
\value{
A list with two data frames or matrices.
}
\description{
\code{rca} computes complexity indices following the definitions
from \insertCite{measuringcomplexity2015;textual}{economiccomplexity}
}
\details{
Given a two data frames or matrices with proximity values, this
function obtains a simplified network in two steps:

1) Creates a network skeleton by appliying the minimum spanning tree
algorithm from the igraph package, but multiplying proximities by minus one,
so that the strongest links are considered for the network skeleton.

2) Appends additional links to the skeleton by aading the links with
proximity values above a user-defined cutoff.
}
\examples{
projections(
  ec_output_demo$proximity$proximity_c,
  ec_output_demo$proximity$proximity_p
)

}
\references{
For more information about visualizing bipartite networks projections see:

\insertRef{human2007}{economiccomplexity}

\insertRef{atlas2014}{economiccomplexity}

and the references therein.
}
\seealso{
\code{\link[economiccomplexity]{proximity}}
}
\keyword{functions}
