% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_risk.R
\name{aggregate_risk}
\alias{aggregate_risk}
\title{Compute High-Complexity Multi-Risk Scores and (Eco)system Risk}
\usage{
aggregate_risk(risk_results, method = "mean")
}
\arguments{
\item{risk_results}{Risk score for each state indicator ~ pressure ~
type combination, derived from the function \code{\link{risk}}
or \code{\link{vulnerability}}.}

\item{method}{Character indicating the method for aggregating the pressures and
state indicators to multiple risk scores and the ecosystem risk score.
The use can choose between (arithmetic) \code{mean}, \code{median}, \code{sum}, \code{maximum}
and \code{minimum}. Default is the arithmetic mean.}
}
\value{
The function returns a list containing three sublists, first the multi-state
indicator risk list, containing the risks and uncertainties aggregated per
pressure, type and pathway.
Second the multi-pressure risk list, where risks and uncertainties are aggregated
per state indicator and type and pathway. The third list contains the ecosystem
risks, which aggregates the multi-pressure risk and uncertainty scores per
type and pathway.
}
\description{
The function \code{aggregate_risk} uses the output of the risk function or
the vulnerability function. The risk or vulnerability scores are aggregated
in three ways:
\enumerate{
\item as multi-pressure risk per state indicator, representing the overall
effect on one indicator
\item as multi- state indicator risk per pressure, representing the overall
effect each pressure has on all state indicators
\item as ecosystem risk, the combined multi-pressure risks of all indicators.
}
}
\details{
The returned lists are required in the plotting functions \code{\link{plot_radar}}
and \code{\link{plot_heatmap}}.
The aggregated scores are calculated for each type and pathway combination
individually and across all types and pathways. If only one type and/or one
pathway has been evaluated beforehand, the results will be the same for the
different combinations.
}
\examples{
### Demo with example output from the risk() function based on expert scores
# (where direct and direct/indirect effects were evaluated)

# Calculate mean risks scores per indicator/pressure/ecosystem:
mean_risk <- aggregate_risk(
  risk_results = ex_output_risk_expert,
  method = "mean" # default
)
mean_risk
# Calculate median risks scores:
aggregate_risk(
  risk_results = ex_output_risk_expert,
  method = "median"
)
# Calculate maximum risks scores:
aggregate_risk(
  risk_results = ex_output_risk_expert,
  method = "maximum"
)


### Demo with example output from the risk() function based on modelled
#   scores (where only direct/indirect effects were evaluated)

# Calculate mean risks scores:
aggregate_risk(risk_results = ex_output_risk_model)


### Demo with combined expert-based and model-based pathways

combined_risk <- rbind(ex_output_risk_expert, ex_output_risk_model)
aggr_risk <- aggregate_risk(risk_results = combined_risk)
aggr_risk

aggr_risk$multi_indicator_risk |>
  dplyr::filter(type == "combined", pathway == "combined")
aggr_risk$multi_pressure_risk |>
  dplyr::filter(type == "combined", pathway == "combined")
aggr_risk$ecosystem_risk |>
  dplyr::filter(type == "combined", pathway == "combined")


### Demo with vulnerability scores using example output data from
#   vulnerability() based on modelled scores

aggregate_risk(risk_results = ex_output_vulnerability_model)
}
\seealso{
\code{\link{vulnerability}}, \code{\link{risk}},
\code{\link{plot_radar}}, \code{\link{plot_heatmap}}
}
