% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ex_expert_exposure}
\alias{ex_expert_exposure}
\title{Expert-based exposure scores for five pressures}
\format{
A data frame with 5 observations and 9 variables (values randomly assigned).
\describe{
\item{pressure}{Environmental or anthropogenic pressure.}
\item{magnitude}{Score for the magnitude pressure change.}
\item{frequency}{Score for the frequency or duration of pressure effect.}
\item{trend}{Score for the future trend of pressure.}
\item{spatial}{Score for the spatial extent of pressure change.}
\item{uncertainty_magnitude}{Uncertainty of magnitude score.}
\item{uncertainty_frequency}{Uncertainty of frequency score.}
\item{uncertainty_trend}{Uncertainty of trend score.}
\item{uncertainty_spatial}{Uncertainty of spatial extent score.}
}
}
\usage{
ex_expert_exposure
}
\description{
This Baltic Sea demo dataset contains expert-assigned scores for five
environmental and anthropogenic pressures, detailing individual exposure
components and their associated uncertainties. The dataset was initialized
using the template function \code{\link{create_template_exposure}}.
}
\details{
Exposure scores range from 1 (low) to 5 (high), while uncertainties range
from 1 (low) to 3 (high). This dataset can be used as input for the function
\code{\link{calc_exposure}}.
}
\keyword{datasets}
