% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineTrajectories.R
\name{defineTrajectories}
\alias{defineTrajectories}
\alias{trajectories}
\title{Trajectory definition}
\usage{
defineTrajectories(d, sites, surveys = NULL, times = NULL)
}
\arguments{
\item{d}{A symmetric \code{\link{matrix}} or an object of class \code{\link{dist}} containing the distance values between pairs of ecological states..}

\item{sites}{A character vector indicating the ecological entity (site, individual, community) corresponding to each ecological state (other types are converted to character).}

\item{surveys}{An integer vector indicating the survey corresponding to each ecological state (only necessary when surveys are not in order).}

\item{times}{A numeric vector indicating survey times (if missing, survey times are made equal to surveys).}
}
\value{
An object (list) of class \code{trajectories} with the following elements:
\itemize{
\item{\code{d}: An object of class \code{\link{dist}} containing relationships between ecological states}
\item{\code{metadata}: A data frame describing trajectory states, with the following columns:
\itemize{
\item{\code{sites}: A character vector indicating the ecological entity corresponding to each ecological state.}
\item{\code{surveys}: An integer vector indicating the survey corresponding to each ecological state.}
\item{\code{times}: A numeric vector indicating survey times.}
}
}
}
}
\description{
Defines data structures for trajectory analysis
}
\examples{
#Description of entities (sites) and surveys
entities <- c("1","1","1","2","2","2")
surveys <- c(1,2,3,1,2,3)
  
#Raw data table
xy<-matrix(0, nrow=6, ncol=2)
xy[2,2]<-1
xy[3,2]<-2
xy[4:6,1] <- 0.5
xy[4:6,2] <- xy[1:3,2]
xy[6,1]<-1

d <- dist(xy)

# Defines trajectories
x <- defineTrajectories(d, entities, surveys)
x
}
\seealso{
\code{\link{subsetTrajectories}}
}
