% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeRecombinator.R
\name{makeRecombinator}
\alias{makeRecombinator}
\title{Construct a recombination operator.}
\usage{
makeRecombinator(recombinator, name, description,
  supported = getAvailableRepresentations(), params = list(),
  n.parents = 2L, n.children = NULL)
}
\arguments{
\item{recombinator}{[\code{function}]\cr
Actual mutation operator.}

\item{name}{[\code{character(1)}]\cr
Name of the recombinator.}

\item{description}{[\code{character(1)}]\cr
Short description of how the recombinator works.}

\item{supported}{[\code{character}]\cr
Vector of strings/names of supported parameter representations. For example
'permutation', 'float', 'binary'.}

\item{params}{[\code{list}]\cr
Named list of the parameters the operator has been initialized with.
Default is the empty list.}

\item{n.parents}{[\code{integer(1)}]\cr
Number of parents supported.}

\item{n.children}{[\code{integer(1)}]\cr
How many children does the recombinator produce?
Default is \code{1}.}
}
\value{
[\code{ecr_recombinator}]
  Recombinator object.
}
\description{
Helper function which constructs a recombinator, i. e., a recombination operator.
}
\note{
If a recombinator returns more than one child, the \code{multiple.children}
parameter needs to be \code{TRUE}, which is the default. In case of multiple
children produced these have to be placed within a list.
}

