% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd.R
\name{partial_dependence}
\alias{partial_dependence}
\title{Partial dependence using random forests}
\usage{
partial_dependence(fit, vars, n, interaction, uniform, data, ...)
}
\arguments{
\item{fit}{object of class 'RandomForest', 'randomForest', 'rfsrc', or `ranger`}

\item{vars}{a character vector of the predictors of interest}

\item{n}{two dimensional integer vector giving the resolution of the grid. the first element gives the grid on \code{vars} and the second on the other columns, which are subsampled.}

\item{interaction}{logical, if 'vars' is a vector, does this specify an interaction or a list of bivariate partial dependence}

\item{uniform}{logical, indicates whether a uniform or random grid is to be construct
partial dependence calculation}

\item{data}{the data.frame used to fit the model, only needed for 'randomForest'}

\item{...}{additional arguments to be passed to \code{marginalPrediction}}
}
\value{
a data.frame with the partial dependence of 'vars'
if 'vars' has length = 1 then the output will be a data.frame with a column for the predicted value at each value of 'vars', averaged over the values of all other predictors.
if 'vars' has length > 1 and interaction is true or false then the output will be a data.frame with a column for each element of 'vars' and the predicted value for each combination.
}
\description{
Calculates the partial dependence of the response on an arbitrary dimensional set of predictors
from a fitted random forest object from the party, randomForest, randomForestSRC, or ranger packages
}
\examples{
library(randomForest)
library(edarf)

data(iris)
data(swiss)

## classification
fit = randomForest(Species ~ ., iris)
pd = partial_dependence(fit, c("Sepal.Width", "Sepal.Length"),
  data = iris[, -ncol(iris)])
pd_int = partial_dependence(fit, c("Petal.Width", "Sepal.Length"), 
  interaction = TRUE, data = iris[, -ncol(iris)])

## Regression
fit = randomForest(Fertility ~ ., swiss)
pd = partial_dependence(fit, c("Education", "Examination"), data = swiss[, -1])
pd_int = partial_dependence(fit, c("Education", "Examination"),
  interaction = TRUE, data = swiss[, -1])
}
\references{
Friedman, Jerome H. "Greedy function approximation: a gradient boosting machine." Annals of statistics (2001): 1189-1232.
}
\seealso{
\code{\link{plot_pd}} for plotting \code{partial_dependence}.
}
