% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_presence.R
\name{activity_presence}
\alias{activity_presence}
\title{Metric: Activity Presence}
\usage{
activity_presence(eventlog)
}
\arguments{
\item{eventlog}{The event log to be used. An object of class
\code{eventlog}.}
}
\description{
Calculates for each activity type in what percentage of cases it is present.
}
\examples{
\dontrun{
data <- data.frame(case = rep("A",5),
activity_id = c("A","B","C","D","E"),
activity_instance_id = 1:5,
lifecycle_id = rep("complete",5),
timestamp = 1:5,
resource = rep("resource 1", 5))

log <- bupaR::eventlog(data,case_id = "case",
activity_id = "activity_id",
activity_instance_id = "activity_instance_id",
lifecycle_id = "lifecycle_id",
timestamp = "timestamp",
resource_id = "resource")

activity_presence(log)
}
}
