% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_precedence_conditions.R
\name{filter_precedence_condition}
\alias{filter_precedence_condition}
\title{Filter: precedence relations}
\usage{
filter_precedence_condition(
  eventlog,
  antecedent_condition,
  consequent_condition,
  precedence_type,
  reverse
)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{antecedent_condition, consequent_condition}{The antecendent and consequent conditions}

\item{precedence_type}{When \code{directly_follows}, the consequent condition should hold immediately after the antecedent condition hold
When \code{eventually_follows}, other events are allowed to happen in between.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Filters cases based on the precedence relations between two sets of activities.
}
\details{
In order to extract a subset of an event log which conforms with a set of precedence rules, one can use the filter_precedence method. There are two types of
precendence relations which can be tested: activities that should directly follow each other,
or activities that should eventually follow each other. The type can be set with the precedence type argument.
Further, the filter requires a vector of one or more antecedents (containing activity labels), and one or more consequents. Finally, also a filter method argument
can be set. This argument is relevant when there is more than one antecedent or consequent.
In such a case, you can specify that all possible precedence combinations must be present (all), at least one of them (one of), or none (none).
}
\seealso{
\code{vignette("filters", "edeaR")}
}
