% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment}
\alias{augment}
\alias{augment.log_metric}
\alias{augment.case_metric}
\alias{augment.activity_metric}
\alias{augment.resource_metric}
\alias{augment.resource_activity_metric}
\alias{augment.trace_metric}
\title{Augment log with results from metric computation.}
\usage{
augment(metric, log, columns, prefix = "")

\method{augment}{log_metric}(metric, log, columns, prefix = "")

\method{augment}{case_metric}(metric, log, columns, prefix = "")

\method{augment}{activity_metric}(metric, log, columns, prefix = "")

\method{augment}{resource_metric}(metric, log, columns, prefix = "")

\method{augment}{resource_activity_metric}(metric, log, columns, prefix = "")

\method{augment}{trace_metric}(metric, log, columns, prefix = "")
}
\arguments{
\item{metric}{Metric computed by edeaR}

\item{log}{Object of class \code{eventlog} or \code{activitylog} that was used to compute the metric.}

\item{columns}{A character vector of column names from the metric that you want to add to the log. If missing, defautls to all columns.}

\item{prefix}{A character prefix to be added to the newly added metric columns in the log.}
}
\value{
Object of class \code{eventlog} or \code{activitylog}. Same class as the log input.
}
\description{
Augment log with results from metric computation.
}
\section{Methods (by class)}{
\itemize{
\item \code{log_metric}: Augment log metric

\item \code{case_metric}: Augment case metric

\item \code{activity_metric}: Augment activity metric

\item \code{resource_metric}: Augment resource metric

\item \code{resource_activity_metric}: Augment resource-activity metric

\item \code{trace_metric}: Augment trace metric
}}

