% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHeaderFunctions.R
\name{readEdfHeader}
\alias{readEdfHeader}
\alias{readBdfHeader}
\title{Read EDF(+) or BDF(+)  file header}
\usage{
readEdfHeader(fileName)
}
\arguments{
\item{fileName}{The full path to the EDF(+)/BDF(+) file to be read.}
}
\value{
an object of class ebdfHeader
}
\description{
The function reads the header of an EDF (European Data Format) file, an EDF+ file,
   an BDF file, or an BDF+ file
}
\section{Details}{

The object returned contains also an object of class ebdfSHeaders.
Both objects ebdfHeader and ebdfSHeaders have supporting S3 print and summary functions.\cr
For object details see the package vignette.
}

\section{Acknowledgement}{

   This package has used code from:
   \itemize{
     \item edf.R version 0.3 (27-11-2013), http://feschet.fr/?p=11
     \item the work of Henelius Andreas as of July 2015, https://github.com/bwrc/edf
   }
}

\examples{
# Examples from the vignette
libDir <- system.file ("extdata", package="edfReader")
# a continuous recording
CFile <- paste (libDir, '/edfPlusC.edf', sep='')
CHdr  <- readEdfHeader (CFile)
CHdr                   # print the header
summary (CHdr)         # print a header summary
str (CHdr)             # look to the details
CHdr$sHeaders          # print the signal headers
summary(CHdr$sHeaders) # print a signal headers summary
str(CHdr$sHeaders)     # look to the signal header details
# for a discontinuous recording
DFile <- paste (libDir, '/bdfPlusD.bdf', sep='')
# and proceed as above to read the header and to show the results
}
\seealso{
\code{\link{edfReader}}, \code{\link{readEdfSignals}}\cr
   For the vignette use the console command:\cr
   \code{vignette('edfReaderVignette', package = "edfReader")}\cr
   or click on \code{Index} below.
}
