% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serve.R
\name{serve_table}
\alias{serve_table}
\title{Serve edibble table}
\usage{
serve_table(.edibble, use_labels = FALSE, ..., .record = TRUE)
}
\arguments{
\item{.edibble}{An edibble design (\code{edbl_design}), an edibble data frame (\code{edbl_table}) or an
object that contains the edibble data frame in the attribute
\code{design}.}

\item{use_labels}{To show the labels instead of names.}

\item{...}{Either a name-value pair or a series of the names.}

\item{.record}{A logical value. This indicates whether to record this
code step. The default is TRUE. It should remain TRUE unless this
function is used as a wrapper in other code.}
}
\value{
An \code{edbl} data frame with columns defined by vertices and
rows displayed only if the vertices are connected and reconcile for output.
}
\description{
This converts an edibble graph object to a data frame called edibble.
This function should be used when the design is in the final form
(or close to the final form). The table can only be formed when the
variables can be reconciled, otherwise it will be a data frame with
zero rows.
}
\examples{
design("Completely Randomised Design") \%>\%
  set_units(unit = 28) \%>\%
  set_trts(trt = 6) \%>\%
  allot_trts(trt ~ unit) \%>\%
  assign_trts("random", seed = 521) \%>\%
  serve_table()
}
\seealso{
Other user-facing functions: 
\code{\link{allot}},
\code{\link{design}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{set_rcrds}()},
\code{\link{set_trts}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
