% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{customButton}
\alias{customButton}
\title{Generate a custom button for \code{\link{eDT}}}
\usage{
customButton(id, label, icon = "", disabled = FALSE)
}
\arguments{
\item{id}{\code{character(1)}, namespaced id}

\item{label}{\code{character(1)}}

\item{icon}{\code{shiny::icon}}

\item{disabled}{\code{logical}. Whether or not the button should start in a disabled state.}
}
\value{
list to be used in \code{eDT(options = list(buttons = xxx))}
}
\description{
Generate a custom button for \code{\link{eDT}}
}
\details{
Combines elements of \code{shiny::actionButton} and \href{https://datatables.net/reference/option/}{datatable options}
}
\examples{
if(interactive()){

  ui <- eDTOutput("data")
  server <- function(input,output,session){
    b <- customButton('print', label = 'print')
    eDT_result <- eDT(id = "data", mtcars, options = list(buttons = list("save", b)))
    observeEvent(input$print,{
          print(eDT_result$state())
    })
  }
  shinyApp(ui,server)
}

}
\author{
Jasper Schelfhout
}
