% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixOperators.R
\name{edm2psd}
\alias{edm2psd}
\title{Linear Matrix Operator}
\usage{
edm2psd(D, V = NULL)
}
\arguments{
\item{D}{A matrix in the set D_{n}^{-}.}

\item{V}{A projection matrix satisfying V'1 = 0 and VV' = I}
}
\value{
S A symmetric, positive semi-definite matrix
}
\description{
\code{edm2psd} Convert an Euclidean Distance Matrix to a Positive Semi-definite Matrix
}
\details{
For a matrix D in \eqn{D_{n}^{-}}, edm2psd will be in the space of positive
semi-definite matrices. Therefore, if D also has zero diagonal, we have the following property:

D is a Euclidean Distance Matrix if and only if edm2psd is positive semi-definite.

This operator gives us another method to characterize the existence of a Euclidean distance matrix.
}
\examples{

XY <- cbind(runif(100,0,1),runif(100,0,1))
D <- dist(XY)
edm2psd(as.matrix(D))

}
\seealso{
\code{\link{psd2edm}} \code{\link{edm2gram}}
}

