% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-download.R
\name{nat_data_download}
\alias{nat_data_download}
\title{Download DataFrame containing the data associated with Australian federal electorates}
\usage{
nat_data_download(year, ...)
}
\arguments{
\item{year}{Desired year, must be one of 2001, 2004, 2007, 2010, 2011, 2013, 2016, 2019}

\item{...}{Additional arguments passed to `download.file`

Downloads and returns a DataFrame containing the points that outline the polygons 
for each of the Australian electorates in the desired federal election. 
This object is obtained using the `nat_data_download` function. The data were obtained from the 
Australian Electoral Commission and the Australian Bureau of Statistics.}
}
\value{
A DataFrame with data associated with each of the Australian federal electorates
}
\description{
Download DataFrame containing the data associated with Australian federal electorates
}
\examples{
\dontrun{
nat_map16 <- nat_map_download(year = 2016)
nat_data16 <- nat_data_download(year = 2016)
# Plot a map of the electorates
library(sp)
plot(sF_16)
}

}
