% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{eem_cut}
\alias{eem_cut}
\title{Cut emission and/or excitation wavelengths from EEMs}
\usage{
eem_cut(eem, ex, em)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{ex}{A numeric vector with range of excitation wavelengths to be kept.}

\item{em}{A numeric vector with range of emission wavelengths to be kept.}
}
\value{
An object of class \code{eemlist}.
}
\description{
Cut emission and/or excitation wavelengths from EEMs
}
\examples{
# Open the fluorescence eem
file <- system.file("extdata/cary/scans_day_1/", "sample1.csv", package = "eemR")

eem <- eem_read(file)
plot(eem)

# Cut few excitation wavelengths
eem <- eem_cut(eem, ex = c(220, 300), em = c(325, 500))
plot(eem)
}

