% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.lm.R
\name{autoplot.lm}
\alias{autoplot.lm}
\title{A function to replicate the basic plot function for linear models in ggplot2}
\usage{
\method{autoplot}{lm}(object, which = c(1:6), mfrow = c(3, 2), ...)
}
\arguments{
\item{object}{a linear model object from \code{\link{lm}}}

\item{which}{which of the tests do we want to display output from}

\item{mfrow}{Describes the layout of the resulting function in the plot frames}

\item{...}{additional parameters to pass through}
}
\value{
A ggplot2 object that mimics the functionality of a plot of linear model.
}
\description{
This uses ggplot2 to replicate the plot functionality for lm 
in ggplot2 and allow themes.
}
\examples{
# Univariate
a <- runif(1000)
b <- 7 * a + rnorm(1)
mymod <- lm(b~a)
autoplot(mymod)
# Multivariate
data(mpg)
mymod <- lm(cty~displ + cyl + drv, data=mpg)
autoplot(mymod)

}
\references{
Modified from: http://librestats.com/2012/06/11/autoplot-graphical-methods-with-ggplot2/
}
\seealso{
\code{\link{plot.lm}} which this function mimics
}

