% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_tFz_to_d.R, R/convert_tFz_to_r.R
\name{t_to_d}
\alias{t_to_d}
\alias{convert_t_to_d}
\alias{z_to_d}
\alias{convert_z_to_d}
\alias{F_to_d}
\alias{convert_F_to_d}
\alias{t_to_r}
\alias{convert_t_to_r}
\alias{z_to_r}
\alias{convert_z_to_r}
\alias{F_to_r}
\alias{convert_F_to_r}
\title{Convert test statistics (t, z, F) to effect sizes of differences (Cohen's d) or association (\strong{partial} r)}
\usage{
t_to_d(t, df_error, paired = FALSE, ci = 0.95, pooled, ...)

convert_t_to_d(t, df_error, paired = FALSE, ci = 0.95, pooled, ...)

z_to_d(z, n, paired = FALSE, ci = 0.95, pooled, ...)

convert_z_to_d(z, n, paired = FALSE, ci = 0.95, pooled, ...)

F_to_d(f, df, df_error, paired = FALSE, ci = 0.95, pooled, ...)

convert_F_to_d(f, df, df_error, paired = FALSE, ci = 0.95, pooled, ...)

t_to_r(t, df_error, ci = 0.95, ...)

convert_t_to_r(t, df_error, ci = 0.95, ...)

z_to_r(z, n, ci = 0.95, ...)

convert_z_to_r(z, n, ci = 0.95, ...)

F_to_r(f, df, df_error, ci = 0.95, ...)

convert_F_to_r(f, df, df_error, ci = 0.95, ...)
}
\arguments{
\item{t, f, z}{The t, the F or the z statistics.}

\item{paired}{Should the estimate accout for the t-value being testing the difference between dependant means?}

\item{ci}{Confidence Interval (CI) level}

\item{pooled}{Deprecated. Use \code{paired}.}

\item{...}{Arguments passed to or from other methods.}

\item{n}{The number of observations (the sample size).}

\item{df, df_error}{Degrees of freedom of numerator or of the error estimate (i.e., the residuals).}
}
\value{
A data frame with the effect size(s) between 0-1, and confidence interval(s)
}
\description{
These functions are convenience functions to convert t, z and F test statistics to Cohen's d and
\strong{partial} r. These are useful in cases where the data required to compute these are not easily
available or their computation is not straightforward (e.g., in liner mixed models, contrasts, etc.).
\cr
See \href{https://easystats.github.io/effectsize/articles/from_test_statistics.html}{Effect Size from Test Statistics vignette.}
}
\details{
These functions use the following formulae:
\cr\cr
\deqn{r_{partial} = t / \sqrt{t^2 + df_{error}}}
\cr\cr
\deqn{r_{partial} = z / \sqrt{z^2 + N}}
\cr\cr
\deqn{Cohen's d = 2 * t / \sqrt{df_{error}}}
\cr\cr
\deqn{Cohen's d_z = t / \sqrt{df_{error}}}
\cr\cr
\deqn{Cohen's d = 2 * z / \sqrt{N}}

\subsection{Confidence Intervals}{
Confidence intervals are estimated using the Noncentrality parameter method;
These methods searches for a the best \code{ncp} (non-central parameters) for
of the noncentral F distribution for the desired tail-probabilities,
and then convert these \code{ncp}s to the corresponding effect sizes.
}
}
\examples{
## t Tests
res <- t.test(1:10, y = c(7:20), var.equal = TRUE)
t_to_d(t = res$statistic, res$parameter)
t_to_r(t = res$statistic, res$parameter)

res <- with(sleep, t.test(extra[group == 1], extra[group == 2], paired = TRUE))
t_to_d(t = res$statistic, res$parameter, paired = TRUE)
t_to_r(t = res$statistic, res$parameter)

\donttest{
## Linear Regression
model <- lm(Sepal.Length ~ Sepal.Width + Petal.Length, data = iris)
library(parameters)
(param_tab <- parameters(model))

t_to_r(param_tab$t[2:3], param_tab$df_error[2:3])

# How does this compare to actual partial correlations?
if (require("correlation")) {
  correlation::correlation(iris[,1:3], partial = TRUE)[1:2, c(2,3,7,8)]
}

## Use with emmeans based contrasts (see also t_to_eta2)
if (require(emmeans)) {
  warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)

  conts <- summary(pairs(emmeans(warp.lm,  ~ tension | wool)))
  t_to_d(conts$t.ratio, conts$df)
}

}
}
\references{
\itemize{
  \item Friedman, H. (1982). Simplified determinations of statistical power, magnitude of effect and research sample sizes. Educational and Psychological Measurement, 42(2), 521-526. \doi{10.1177/001316448204200214}
  \item Wolf, F. M. (1986). Meta-analysis: Quantitative methods for research synthesis (Vol. 59). Sage.
  \item Rosenthal, R. (1991). Meta-analytic procedures for social research. Newbury Park, CA: SAGE Publications, Incorporated.
  \item Steiger, J. H. (2004). Beyond the F test: Effect size confidence intervals and tests of close fit in the analysis of variance and contrast analysis. Psychological Methods, 9, 164-182.
  \item Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and calculation of confidence intervals that are based on central and noncentral distributions. Educational and Psychological Measurement, 61(4), 532-574.
}
}
