% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret.R
\name{interpret}
\alias{interpret}
\title{Generic function for interpretation}
\usage{
interpret(x, rules)
}
\arguments{
\item{x}{Vector of value break points (edges defining categories).}

\item{rules}{Set of \code{\link[=rules]{rules()}}.}
}
\description{
Interpret a value based on a set of rules. See \code{\link[=rules]{rules()}}.
}
\examples{
rules_grid <- rules(c(0.01, 0.05), c("very significant", "significant", "not significant"))
interpret(0.001, rules_grid)
interpret(0.021, rules_grid)
interpret(0.08, rules_grid)
interpret(c(0.01, 0.005, 0.08), rules_grid)

interpret(c(0.35, 0.15), c("small" = 0.2, "large" = 0.4))
interpret(c(0.35, 0.15), rules(c(0.2, 0.4), c("small", "medium", "large")))
}
\seealso{
rules
}
