% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_r.R
\name{interpret_r}
\alias{interpret_r}
\title{Interpret correlation}
\usage{
interpret_r(r, rules = "funder2019")
}
\arguments{
\item{r}{Value or vector of correlation coefficient.}

\item{rules}{Can be \code{"funder2019"} (default), \code{"gignac2016"}, \code{"cohen1988"}, \code{"evans1996"} or custom set of \code{\link[=rules]{rules()}}.}
}
\description{
Interpret correlation
}
\section{Rules}{


Rules apply positive and negative \emph{r} alike.
\itemize{
\item Funder & Ozer (2019) (\code{"funder2019"}; default)
\itemize{
\item \strong{r < 0.05} - Tiny
\item \strong{0.05 <= r < 0.1} - Very small
\item \strong{0.1 <= r < 0.2} - Small
\item \strong{0.2 <= r < 0.3} - Medium
\item \strong{0.3 <= r < 0.4} - Large
\item \strong{r >= 0.4} - Very large
}
\item Gignac & Szodorai (2016) (\code{"gignac2016"})
\itemize{
\item \strong{r < 0.1} - Very small
\item \strong{0.1 <= r < 0.2} - Small
\item \strong{0.2 <= r < 0.3} - Moderate
\item \strong{r >= 0.3} - Large
}
\item Cohen (1988) (\code{"cohen1988"})
\itemize{
\item \strong{r < 0.1} - Very small
\item \strong{0.1 <= r < 0.3} - Small
\item \strong{0.3 <= r < 0.5} - Moderate
\item \strong{r >= 0.5} - Large
}
\item Evans (1996) (\code{"evans1996"})
\itemize{
\item \strong{r < 0.2} - Very weak
\item \strong{0.2 <= r < 0.4} - Weak
\item \strong{0.4 <= r < 0.6} - Moderate
\item \strong{0.6 <= r < 0.8} - Strong
\item \strong{r >= 0.8} - Very strong
}
}
}

\examples{
interpret_r(.015)
interpret_r(c(.5, -.02))
}
\references{
\itemize{
\item Funder, D. C., & Ozer, D. J. (2019). Evaluating effect size in psychological research: sense and nonsense. Advances in Methods and Practices in Psychological Science.
\item Gignac, G. E., & Szodorai, E. T. (2016). Effect size guidelines for individual differences researchers. Personality and individual differences, 102, 74-78.
\item Cohen, J. (1988). Statistical power analysis for the behavioural sciences.
\item Evans, J. D. (1996). Straightforward statistics for the behavioral sciences. Thomson Brooks/Cole Publishing Co.
}
}
\seealso{
Page 88 of APA's 6th Edition.
}
