% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohens_d.R
\name{cohens_d}
\alias{cohens_d}
\alias{hedges_g}
\alias{glass_delta}
\title{Effect size for differences}
\usage{
cohens_d(
  x,
  y = NULL,
  data = NULL,
  pooled_sd = TRUE,
  mu = 0,
  paired = FALSE,
  ci = 0.95,
  verbose = TRUE,
  ...,
  correction
)

hedges_g(
  x,
  y = NULL,
  data = NULL,
  correction = 1,
  pooled_sd = TRUE,
  mu = 0,
  paired = FALSE,
  ci = 0.95,
  verbose = TRUE,
  ...
)

glass_delta(
  x,
  y = NULL,
  data = NULL,
  mu = 0,
  ci = 0.95,
  iterations = 200,
  verbose = TRUE,
  ...,
  correction
)
}
\arguments{
\item{x}{A formula, a numeric vector, or a character name of one in \code{data}.}

\item{y}{A numeric vector, a grouping (character / factor) vector, a or a
character  name of one in \code{data}. Ignored if \code{x} is a formula.}

\item{data}{An optional data frame containing the variables.}

\item{pooled_sd}{If \code{TRUE} (default), a \code{\link[=sd_pooled]{sd_pooled()}} is used (assuming equal
variance). Else the mean SD from both groups is used instead.}

\item{mu}{a number indicating the true value of the mean (or
    difference in means if you are performing a two sample test).}

\item{paired}{If \code{TRUE}, the values of \code{x} and \code{y} are considered as paired.
This produces an effect size that is equivalent to the one-sample effect
size on \code{x - y}.}

\item{ci}{Confidence Interval (CI) level}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods.}

\item{correction}{Type of small sample bias correction to apply to produce
Hedges' \emph{g}. Can be \code{1} for Hedges and Olkin's original correction
(default) or \code{2} for Hunter and Schmidt's correction (see McGrath & Meyer,
2006).}

\item{iterations}{The number of bootstrap replicates for computing confidence intervals. Only applies when \code{ci} is not \code{NULL}.}
}
\value{
A data frame with the effect size ( \code{Cohens_d}, \code{Hedges_g},
\code{Glass_delta}) and their CIs (\code{CI_low} and \code{CI_high}).
}
\description{
Compute effect size indices for standardized differences: Cohen's \emph{d},
Hedges' \emph{g} and Glass’s \emph{delta}. (This function returns the \strong{population}
estimate.)
\cr\cr
Both Cohen's \emph{d} and Hedges' \emph{g} are the estimated the standardized
difference between the means of two populations. Hedges' \emph{g} provides a bias
correction to Cohen's \emph{d} for small sample sizes. For sample sizes > 20, the
results for both statistics are roughly equivalent. Glass’s \emph{delta} is
appropriate when the standard deviations are significantly different between
the populations, as it uses only the \emph{second} group's standard deviation.
}
\details{
\subsection{Confidence Intervals for Glass' \emph{delta}}{

Confidence Intervals for Glass' \emph{delta} are estimated using the bootstrap
method.
}
}
\note{
The indices here give the population estimated standardized difference.
Some statistical packages give the sample estimate instead (without
applying Bessel's correction).
}
\section{Confidence Intervals}{

Unless stated otherwise, confidence intervals are estimated using the
Noncentrality parameter method; These methods searches for a the best
non-central parameters (\code{ncp}s) of the noncentral t-, F- or Chi-squared
distribution for the desired tail-probabilities, and then convert these
\code{ncp}s to the corresponding effect sizes. (See full \link{effectsize-CIs} for
more.)
}

\examples{
cohens_d(sleep$extra, sleep$group)
hedges_g("extra", "group", data = sleep)

cohens_d(sleep$extra[sleep$group==1], sleep$extra[sleep$group==2], paired = TRUE)

cohens_d(mpg ~ am, data = mtcars)
cohens_d(mpg ~ am, data = mtcars, pooled_sd = FALSE)
cohens_d(mpg ~ am, data = mtcars, mu = -5)
hedges_g(mpg ~ am, data = mtcars)
if (require(boot)) glass_delta(mpg ~ am, data = mtcars)

print(cohens_d(mpg ~ am, data = mtcars), append_CL = TRUE)
}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
\item Hedges, L. V. & Olkin, I. (1985). Statistical methods for meta-analysis. Orlando, FL: Academic Press.
\item Hunter, J. E., & Schmidt, F. L. (2004). Methods of meta-analysis: Correcting error and bias in research findings. Sage.
\item McGrath, R. E., & Meyer, G. J. (2006). When effect sizes disagree: the case of r and d. Psychological methods, 11(4), 386.
}
}
\seealso{
\code{\link[=d_to_common_language]{d_to_common_language()}} \code{\link[=sd_pooled]{sd_pooled()}}

Other effect size indices: 
\code{\link{effectsize}()},
\code{\link{eta_squared}()},
\code{\link{phi}()},
\code{\link{rank_biserial}()},
\code{\link{standardize_parameters}()}
}
\concept{effect size indices}
