% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_oddsratio.R
\name{interpret_oddsratio}
\alias{interpret_oddsratio}
\title{Interpret Odds ratio}
\usage{
interpret_oddsratio(OR, rules = "chen2010", log = FALSE, ...)
}
\arguments{
\item{OR}{Value or vector of (log) odds ratio values.}

\item{rules}{Can be "\verb{chen2010"} (default), \code{"cohen1988"} (through
transformation to standardized difference, see \code{\link[=oddsratio_to_d]{oddsratio_to_d()}}) or custom set
of \code{\link[=rules]{rules()}}.}

\item{log}{Are the provided values log odds ratio.}

\item{...}{Currently not used.}
}
\description{
Interpret Odds ratio
}
\section{Rules}{


Rules apply to OR as ratios, so OR of 10 is as extreme as a OR of 0.1 (1/10).
\itemize{
\item Chen et al. (2010) (\code{"chen2010"}; default)
\itemize{
\item \strong{OR < 1.68} - Very small
\item \strong{1.68 <= OR < 3.47} - Small
\item \strong{3.47 <= OR < 6.71} - Medium
\item **OR >= 6.71 ** - Large
}
\item Cohen (1988) (\code{"cohen1988"}, based on the \code{\link[=oddsratio_to_d]{oddsratio_to_d()}} conversion, see \code{\link[=interpret_cohens_d]{interpret_cohens_d()}})
\itemize{
\item \strong{OR < 1.44} - Very small
\item \strong{1.44 <= OR < 2.48} - Small
\item \strong{2.48 <= OR < 4.27} - Medium
\item **OR >= 4.27 ** - Large
}
}
}

\examples{
interpret_oddsratio(1)
interpret_oddsratio(c(5, 2))

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences
(2nd Ed.). New York: Routledge.
\item Chen, H., Cohen, P., & Chen, S. (2010). How big is a big odds ratio?
Interpreting the magnitudes of odds ratios in epidemiological studies.
Communications in Statistics—Simulation and Computation, 39(4), 860-864.
\item Sánchez-Meca, J., Marín-Martínez, F., & Chacón-Moscoso, S. (2003).
Effect-size indices for dichotomized outcomes in meta-analysis. Psychological
methods, 8(4), 448.
}
}
