% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ego_tergm.R
\name{plot_ego_tergm}
\alias{plot_ego_tergm}
\title{Function to plot role assignments.}
\usage{
plot_ego_tergm(ego_tergm_fit = NULL, plot_indices = NULL,
  node.size = 6, edge.size = 1, edge.color = "grey")
}
\arguments{
\item{ego_tergm_fit}{The output from a fitted "ego_tergm".}

\item{plot_indices}{A vector of indices reflecting the time steps that plots should be returned for.  In networks observed over many time intervals it may be unrealistic to plot every network.}

\item{node.size}{The size of the nodes fed to ggnet2.}

\item{edge.size}{The size of the edges fed to ggnet2.}

\item{edge.color}{The color of edges fed to ggnet2.}
}
\value{
A list of network plots with nodes colored by role assignment.
}
\description{
This function assists the user in interpreting output from the ego_tergm function.
}
\examples{
plots <- plot_ego_tergm(ego_tergm_fit = ego_tergm_fit)
plots[[1]]
plots[[2]]
}
\references{
{
Campbell, Benjamin W. (2018):
 Inferring Latent Roles in Longitudinal Networks.
 \emph{Political Analysis} 26(3): 292-311.  \url{https://doi.org/10.1017/pan.2018.20}
}
}
\keyword{assignments}
\keyword{interpretation}
\keyword{plot}
\keyword{summary}
