% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_rc_good_table.R
\name{ei_rc_good_table}
\alias{ei_rc_good_table}
\title{Create EI Comparison Table}
\usage{
ei_rc_good_table(ei, rc, good, groups, include_good = FALSE)
}
\arguments{
\item{ei}{Table/data frame object result from ei_est_gen. This assumes
beta_yes=FALSE in ei_est_gen(). See example below for beta_yes=TRUE in
ei_est_gen().}

\item{rc}{Table/data frame from EI:RxC process from bayes_table_make()}

\item{good}{Table/data frame from Goodman regression, from
goodman_generalize(). Default is nothing}

\item{groups}{Character vector of voting blocks (e.g., c("Latino", "White"))}

\item{include_good}{Logical, default is FALSE, Set to TRUE if including a
Goodman table/data object}
}
\value{
Object of class ei_compare containing a 1. data.frame() slot of
comparisons across the three models; 2. Character vector of group names used
for later plotting
}
\description{
Takes output from EI model, EI RxC model, Goodman regression, and puts them
into a data frame table for useful analysis and comparison.
}
\note{
Most of the time the user will not include the Goodman table, as they
are interested in the EI vs. EI:RxC comparison
}
\references{
eiPack, King et. al. (http://gking.harvard.edu/eiR)
}
\author{
Loren Collingwood <loren.collingwood@ucr.edu>
}
