% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voter_file_utils.R
\name{merge_voter_file_to_shape}
\alias{merge_voter_file_to_shape}
\title{Merges a voter file to a shape file.}
\usage{
merge_voter_file_to_shape(
  voter_file,
  shape_file,
  crs = NULL,
  coords = c("lon", "lat"),
  voter_id = "voter_id"
)
}
\arguments{
\item{voter_file}{A dataframe denoting the voter file. If it is not a
geometry dataframe, it will be converted to one.}

\item{shape_file}{The shapefile for the region, as an sf object.}

\item{crs}{The PROJ4 string or int for the coordinate reference system.}

\item{coords}{The columns, as a list, that refer to the longitude and
latitude.}

\item{voter_id}{The column for the Voter ID.}
}
\value{
The voter file with unit information attached.
}
\description{
This is achieved by determining the units (e.g., Census block, district,
etc.) for which each voter's address lies within.
}
\details{
This function assumes that the sf package was used to read in the shape
files.
}
