% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{\%index\%}
\alias{\%index\%}
\title{Index a data frame.}
\usage{
rescource \%index\% df
}
\arguments{
\item{rescource}{An \code{elastic_rescource} object that contains the information on the
Elasticsearch cluster, index and document type, where the indexed data will reside. If this does
not already exist, it will be created automatically.}

\item{df}{data.frame whose rows will be indexed as documents in the Elasticsearch cluster.}
}
\description{
Inserting records (or documents) into Elasticsearch is referred to as "indexing' the data. This
function considers each row of a data frame as a document to be indexed into an Elasticsearch
index.
}
\details{
If the data frame contains a column named 'id', then this will be used to assign document ids.
Otherwise, Elasticsearch will automatically assigne the documents random ids.
}
\examples{
\dontrun{
elastic("http://localhost:9200", "iris", "data") \%index\% iris
}
}
\seealso{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-index_.html}
}
