% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-ollama.R
\name{chat_ollama}
\alias{chat_ollama}
\title{Chat with a local Ollama model}
\usage{
chat_ollama(
  system_prompt = NULL,
  turns = NULL,
  base_url = "http://localhost:11434",
  model,
  seed = NULL,
  api_args = list(),
  echo = NULL
)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{model}{The model to use for the chat. The default, \code{NULL}, will pick
a reasonable default, and tell you about. We strongly recommend explicitly
choosing a model for all but the most casual use.}

\item{seed}{Optional integer seed that ChatGPT uses to try and make output
more reproducible.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
To use \code{chat_ollama()} first download and install
\href{https://ollama.com}{Ollama}. Then install some models from the command line,
e.g. with \verb{ollama pull llama3.1} or \verb{ollama pull gemma2}.

This function is a lightweight wrapper around \code{\link[=chat_openai]{chat_openai()}} with
the defaults tweaked for ollama.
\subsection{Known limitations}{
\itemize{
\item Tool calling is not supported with streaming (i.e. when \code{echo} is
\code{"text"} or \code{"all"})
\item Tool calling generally seems quite weak, at least with the models I have
tried it with.
}
}
}
\examples{
\dontrun{
chat <- chat_ollama(model = "llama3.2")
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_bedrock}()},
\code{\link{chat_claude}()},
\code{\link{chat_cortex}()},
\code{\link{chat_databricks}()},
\code{\link{chat_gemini}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_openai}()},
\code{\link{chat_perplexity}()}
}
\concept{chatbots}
