% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarkers.R
\name{get_perf_biomarkers_per_cell_line}
\alias{get_perf_biomarkers_per_cell_line}
\title{Get performance biomarkers per cell line}
\usage{
get_perf_biomarkers_per_cell_line(biomarkers.dirs, node.names)
}
\arguments{
\item{biomarkers.dirs}{a character vector of the biomarker directories, in the
form of \emph{\{path\}/cell_line_name/\{dir\}}. The cell line name directory
should be different for each element of the vector as we use it to fill in the
\code{rownames} of the result \code{data.frame} object. Inside each \emph{\{dir\}}
(the directory name does not matter, but 'biomarkers' is a good choice),
we read the biomarkers from two files (if they exist and are non-empty):
\emph{biomarkers_active} and \emph{biomarkers_inhibited}, which have the
active and inhibited performance biomarkers for each cell line (these files
have a list of node names/biomarkers, one in each line).}

\item{node.names}{a character vector of the node names used in the analysis.
The biomarker names taken from the files inside the given directories must be
a subset of this vector.}
}
\value{
a data.frame, whose columns represent the network nodes and the
rows the cell lines. Possible values for each \emph{cell line-node}
element are either \emph{1} (\emph{active state} biomarker), \emph{-1}
(\emph{inhibited state} biomarker) or \emph{0} (not a biomarker).
}
\description{
Use this function to get the performance biomarkers from the respective
files inside the given list of directories.
}
