% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_avg_activity_diff_mat_based_on_tp_predictions}
\alias{get_avg_activity_diff_mat_based_on_tp_predictions}
\title{Get average activity difference matrix based on the number of true positives}
\usage{
get_avg_activity_diff_mat_based_on_tp_predictions(
  models.synergies.tp,
  models.stable.state,
  penalty = 0
)
}
\arguments{
\item{models.synergies.tp}{an integer vector of TP values. The \emph{names}
attribute must hold the models' names. Consider using the function
\code{\link{calculate_models_synergies_tp}}.}

\item{models.stable.state}{a \code{data.frame} (nxm) with n models and m nodes. The row
names specify the models' names (same order as in the \code{models.synergies.tp}
parameter) whereas the column names specify the network nodes
(gene, proteins, etc.). Possible values for each \emph{model-node element}
can be between \emph{0} (inactive node) and \emph{1} (active node) inclusive.}

\item{penalty}{value between 0 and 1 (inclusive). A value of 0 means no
penalty and a value of 1 is the strickest possible penalty. Default value is 0.
This penalty is used as part of a weighted term to the difference in a value of
interest (e.g. activity or link operator difference) between two group of
models, to account for the difference in the number of models from each
respective model group.}
}
\value{
a matrix whose rows are \strong{vectors of
average node activity state differences} between two groups of models where
the classification was based on the number of true positive predictions.
Rows represent the different classification group matchings, e.g. (1,2) means the
models that predicted 1 TP synergy vs the models that predicted 2 TP
synergies and the columns represent the network's node names.
Values are in the [-1,1] interval.
}
\description{
This function finds all the TP values of the models given (e.g. 0,1,2,3) and
generates every pairwise combination (e.g. the group matchings: (0,1), (1,3),
etc.). Then, it uses the \code{\link{get_avg_activity_diff_based_on_tp_predictions}}
function on each generated classification group matching, comparing thus all
groups of models with different true positive (TP) values, while taking into
account the given \code{penalty} factor and the number of models in each
respective model group.
}
\seealso{
\code{\link{get_vector_diff}}

Other average data difference functions: 
\code{\link{get_avg_activity_diff_based_on_mcc_clustering}()},
\code{\link{get_avg_activity_diff_based_on_specific_synergy_prediction}()},
\code{\link{get_avg_activity_diff_based_on_synergy_set_cmp}()},
\code{\link{get_avg_activity_diff_based_on_tp_predictions}()},
\code{\link{get_avg_activity_diff_mat_based_on_mcc_clustering}()},
\code{\link{get_avg_activity_diff_mat_based_on_specific_synergy_prediction}()},
\code{\link{get_avg_link_operator_diff_based_on_synergy_set_cmp}()},
\code{\link{get_avg_link_operator_diff_mat_based_on_mcc_clustering}()},
\code{\link{get_avg_link_operator_diff_mat_based_on_specific_synergy_prediction}()},
\code{\link{get_avg_link_operator_diff_mat_based_on_tp_predictions}()}
}
\concept{average data difference functions}
