% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/info.nests.R
\name{info.nests}
\alias{info.nests}
\title{Calculte statistics about nests}
\usage{
info.nests(NestsResult = NULL, parameters = NULL, fixed.parameters = NULL,
  SE = NULL, temperatures = NULL, derivate = NULL, test = NULL,
  stopattest = FALSE, M0 = NULL, series = "all", TSP.borders = c("21",
  "26"), embryo.stages = "Caretta caretta", sampling = 1, weight = NULL,
  out = "Likelihood", fill = NULL, SexualisationTRN = NULL,
  progress = FALSE)
}
\arguments{
\item{NestsResult}{A NestsResult file generated by searchR}

\item{parameters}{A set of parameters if result is not provided.}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{SE}{Standard error for each parameter if result is not provided, or replace the one in NestsResult.}

\item{temperatures}{Timeseries of temperatures. Will replace the one in result.}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear}

\item{test}{Mean and SD of size of hatchlings}

\item{stopattest}{True or False, does the plot stops when proxi of size reaches the mean test size.}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{series}{The name or number of the series to be displayed. Only one series can be displayed at a time.}

\item{TSP.borders}{The limits of TSP}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided if show.TSP is TRUE}

\item{sampling}{Number of randomizations to estimate CI. If 1, no CI is estimated.}

\item{weight}{Weights of the different nests to estimate likelihood}

\item{out}{A vector with likelihood and/or metric and/or summary}

\item{fill}{Number of minutes between two records. Create new one if they do not exist. NULL does not change the time of temperature recordings.}

\item{SexualisationTRN}{A set of parameters used to model thermal reaction norm during TSP}

\item{progress}{If FALSE, the progress bar is not shown (useful for using with sweave or knitr)}
}
\value{
A list with three components: likelihood, summary and metric
}
\description{
Calculate statistics about nests\cr
The embryo.stages is a list with stage numbers and relative size as compared to final size at the beginning of the stage.\cr
For example embryo.stages=list(number=21:30, size=c(8.4, 9.4, 13.6, 13.8, 18.9, 23.5, 32.2, 35.2, 35.5, 38.5)/39.33) indicates that the stages 21 begins at the relative size of 8.4/39.33.\cr
series can be indicated as the name of the series, its number or TRUE or FALSE. "all" indicates that all series must be printed.\cr
The summary object is a data.frame composed of these elements:
\itemize{
  \item \code{TimeWeighted.temperature.mean} Average temperature weigthed by the time at each temperature
  \item \code{TimeWeighted.temperature.se} Standard error for the average temperature weigthed by the time at each temperature
  \item \code{TSP.TimeWeighted.temperature.mean} Average temperature during the TSP weigthed by the time at each temperature
  \item \code{TSP.TimeWeighted.temperature.se} Standard error for the average temperature during the TSP weigthed by the time at each temperature
  \item \code{TSP.MassWeighted.temperature.mean} Average temperature during the TSP weigthed by the mass increase at each temperature
  \item \code{TSP.MassWeighted.temperature.se} Standard error for the average temperature during the TSP weigthed by the mass increase at each temperature
  \item \code{TSP.STRNWeighted.temperature.mean} Averaged temperature during the TSP weighted by sexualisation thermal reaction norm
  \item \code{TSP.STRNWeighted.temperature.se} Standard error for temperature during the TSP weighted by sexualisation thermal reaction norm
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.mean} Averaged temperature during the TSP weighted by sexualisation thermal reaction norm and embryo growth
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.se} Standard error for temperature during the TSP weighted by sexualisation thermal reaction norm and embryo growth
  \item \code{TSP.length.mean} Average length of the TSP
  \item \code{TSP.length.se} Standard error for length of the TSP
  \item \code{TSP.begin.mean} Average time of the beginning of the TSP
  \item \code{TSP.begin.se} Standard error for the beginning of the TSP
  \item \code{TSP.end.mean} Average time of the endd of the TSP
  \item \code{TSP.end.se} Standard error for the end of the TSP
  \item \code{incubation.length.mean} Average number of days for the incubation length
  \item \code{incubation.length.se} Standard error for number of days for the incubation length
  \item \code{incubation.first.third} Average day at which the middle third incubation begins
  \item \code{incubation.first.third.se} Standard error for day at which the middle third incubation begins
  \item \code{incubation.second.third} Average day at which the middle third incubation ends
  \item \code{incubation.second.third.se} Standard error at which the middle third incubation ends
  \item \code{MiddleThird.TimeWeighted.temperature.mean} Average temperature during the middle third of incubation
  \item \code{MiddleThird.TimeWeighted.temperature.se} Standard error for the temperature during the middle third of incubation
}
}
\details{
Calculate statistics about nests
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
summary.nests <- info.nests(resultNest_4p, out="summary", sampling=20,
  SE=c(DHA=1.396525, DHH=4.101217, T12H=0.04330405, Rho25=1.00479))
# to get info for all nests at the same time, use
infoall <- info.nests(resultNest_4p)
# it is easier to use after dataframe conversion
infoall.df <- info.nests(resultNest_4p, out="metric", sampling=20,
  SE=c(DHA=1.396525, DHH=4.101217, T12H=0.04330405, Rho25=1.00479))
}
}
\author{
Marc Girondot
}

