% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MovingIncubation.R
\name{MovingIncubation}
\alias{MovingIncubation}
\title{Simulate incubation of a nest with the beginning of incubation varying}
\usage{
MovingIncubation(NestsResult = NULL,
  temperatures.df = stop("A data.frame with timeseries of temperatures must be provided"),
  average.incubation.duration = 60 * 1440, skip = 1, parameters = NULL,
  fixed.parameters = NULL, SE = NULL, derivate = NULL, test = NULL,
  M0 = NULL, TSP.borders = c(21, 26),
  embryo.stages = "Caretta caretta.SCL", SexualisationTRN = NULL,
  replicate.CI = 1, progress = TRUE)
}
\arguments{
\item{NestsResult}{A result file generated by searchR}

\item{temperatures.df}{A data.frame with 2 or 3 columns: Times, Temperatures and Temperatures.end.incubation (facultative)}

\item{average.incubation.duration}{The average time to complete incubation}

\item{skip}{Number of data to skip between two runs}

\item{parameters}{A set of parameters if result is not provided.}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{SE}{Standard error for each parameter if not present in result is not provided (not used still)}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear}

\item{test}{Mean and SD of size of hatchlings as a vector ie test=c(Mean=xx, SD=yy)}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{TSP.borders}{The limits of TSP}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP length}

\item{SexualisationTRN}{A set of parameters used to model thermal reaction norm during TSP}

\item{replicate.CI}{Number of randomizations to estimate CI}

\item{progress}{If TRUE, progression bar is shown (desactivate for sweave or knitr)}
}
\value{
A dataframe with informations about thermosensitive period length and incubation length day by day of incubation
}
\description{
Simulate incubation of a nest with the beginning varying day by day\cr
Temperatures must be in a data.frame with one column (Time) being the time and the second the temperatures (Temperature). A third columns can indicate the temperature at the end of incubation (Temperature.end.incubation). Do not use FormatNests() for this dataframe.
}
\details{
MovingIncubation simulate incubation of a nest with the beginning varying day by day
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
ti <- seq(from=0, to=(60*24*100), by=60)
temp <- rnorm(length(ti), 29, 5)
temp <- temp+ti/(60*24*100)/2
layout(mat=c(1, 2))
parpre <- par(mar=c(4, 4, 1, 1)+0.4)
plot(ti/(60*24), temp, type="l", xlab="Days", ylab="Nest temperature", bty="n", las=1)
out <- MovingIncubation(NestsResult=resultNest_4p,
     temperatures.df=data.frame(Time=ti, Temperature=temp))
with(out, plot(Time/(60*24), Incubation.length.mean/(60*24), xlab="Days along the season",
ylab="Incubation duration", type="l", bty="n", las=1, ylim=c(74, 78)))
par(mar=parpre)
layout(mat=c(1))
}
}
\author{
Marc Girondot
}

