% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_all}
\alias{runBASwebservice_all}
\title{Runs several BAS webservices, starting from an orthographic transcription}
\usage{
runBASwebservice_all(handle, transcriptionAttributeDefinitionName,
  language, orthoAttributeDefinitionName = "ORT",
  canoAttributeDefinitionName = "KAN",
  mausAttributeDefinitionName = "MAU",
  minniAttributeDefinitionName = "MINNI",
  sylAttributeDefinitionName = "MAS",
  canoSylAttributeDefinitionName = "KAS",
  chunkAttributeDefinitionName = "TRN", runMINNI = TRUE,
  patience = 0, resume = FALSE, verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{transcriptionAttributeDefinitionName}{name of the attribute (not level!) containing an orthographic transcription.}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{orthoAttributeDefinitionName}{attribute name for orthographic words}

\item{canoAttributeDefinitionName}{attribute name for canonical pronunciations of words}

\item{mausAttributeDefinitionName}{attribute name for the MAUS segmentation}

\item{minniAttributeDefinitionName}{attribute name for the MINNI segmentation}

\item{sylAttributeDefinitionName}{attribute name for syllable segmentation}

\item{canoSylAttributeDefinitionName}{attribute name for syllabified canonical pronunciations of words}

\item{chunkAttributeDefinitionName}{attribute name for the chunk segmentation.
Please note that the chunk segmentation will only be generated if your emuDB contains
audio files beyond the one minute mark.}

\item{runMINNI}{if set to \code{TRUE} (the default) the MINNI service is also run. As the MINNI serice contains
less languages than the others it can be useful to turn this off.}

\item{patience}{If a web service call fails, it is repeated a further n times, with n being the value of patience.
Must be set to a value between 0 and 3.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
This function calls the BAS webservices G2P, MAUS, Pho2Syl, MINNI and (if necessary) Chunker.
Starting from an orthographic transcription, it derives a tokenized orthographical word tier
using the G2P tool. It also derives canonical pronunciations (in SAMPA) for the words.
If at least one audio file is longer than 60 seconds, the function then calls the Chunker webservice
to presegment the recordings. Subsequently, the webservice MAUS is called to derive a phonetic
segmentation. A second, rough segmentation is created by running the phoneme decoder MINNI.
Finally, syllabification is performed by calling Pho2Syl. \strong{This function requires an internet connection.}
}
\details{
All necessary level, attribute and link definitions are created in the process.
Note that this function will run all BAS webservices with default parameters, with four exceptions:
\itemize{
\item{Chunker: force=rescue}
\item{G2P: embed=maus}
\item{Pho2Syl: wsync=yes}
\item{MAUS: USETRN=[true if Chunker was called or transcription is a segment tier, false otherwise]}
}
If you wish to change parameters, you must use the individual runBASwebservices functions. This will also allow
you to carry out manual corrections in between the steps, or to use different languages for different webservices.
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_chunker}},
  \code{\link{runBASwebservice_g2pForPronunciation}},
  \code{\link{runBASwebservice_g2pForTokenization}},
  \code{\link{runBASwebservice_maus}},
  \code{\link{runBASwebservice_minni}},
  \code{\link{runBASwebservice_pho2sylCanonical}},
  \code{\link{runBASwebservice_pho2sylSegmental}}
}
\concept{BAS webservice functions}
