% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crss.r
\docType{data}
\name{crss}
\alias{crss}
\title{Coordinate reference systems (CRSs) and nicknames}
\format{
An object of class \code{data.frame}. This is a table with "named" coordinate referenbce systems and their well-known-text (WKT2) representation. It can be used as-is, or with \code{\link{getCRS}} to quickly get a WKT for a particular CRS. The fields are as:
\itemize{
\item \code{long}: "Long" name of the CRS
\item \code{short1} and \code{short2}: "Short" names of the CRS
\item \code{region}: Region for which CRS is fit
\item \code{projected}: Is the CRS projected or not?
\item \code{projectionGeometry}: Type of projection (\code{NA}, 'cylindrical', 'conic', or 'planar')
\item \code{datum}: Datum
\item \code{type}: Either 'CRS' or 'data'. The former are proper CRSs, and the latter are those used by popular datasets.
\item \code{wkt2}: WKT2 string.
\item \code{notes}: Notes.
}
}
\usage{
data(crss)
}
\description{
A table of commonly-used coordinate reference systems, their nicknames, and WKT2 (well-known text) strings
}
\examples{

data(crss)
getCRS('North America Albers', nice = TRUE)

}
\keyword{CRS}
\keyword{coordinate}
\keyword{projection}
