% Generated by roxygen2 (4.0.2): do not edit by hand
\name{predict.enpls.en}
\alias{predict.enpls.en}
\title{Make Predictions from a Fitted Ensemble Partial Least Squares Model}
\usage{
\method{predict}{enpls.en}(object, newx, ...)
}
\arguments{
\item{object}{An object of class \code{enpls.en}.}

\item{newx}{new data to predict with}

\item{...}{Other parameters to be passed on to \code{predict}.}
}
\value{
A numeric vector containing the predicted values.
}
\description{
This function make predictions on new data by fitted enpls.en object.
}
\details{
This function make predictions on new data by fitted enpls.en object.
}
\examples{
\donttest{
data(alkanes)
x = alkanes$x
y = alkanes$y

set.seed(42)
enpls.fit = enpls.en(x, y)
y.pred = predict(enpls.fit, newx = x)
plot(y, y.pred, xlim = range(y), ylim = range(y))
abline(a = 0L, b = 1L)}
}
\author{
Nan Xiao <\email{road2stat@gmail.com}>
}
\references{
Dongsheng Cao, Yizeng Liang, Qingsong Xu, Yifeng Yun, and Hongdong Li.
"Toward better QSAR/QSPR modeling: simultaneous outlier detection and
variable selection using distribution of model features."
\emph{Journal of computer-aided molecular design} 25, no. 1 (2011): 67--80.
}
\seealso{
See \code{\link{enpls.en}} for performing ensemble PLS regression.
}

