% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enspls.fit.R
\name{enspls.fit}
\alias{enspls.fit}
\title{Ensemble Sparse Partial Least Squares Regression}
\usage{
enspls.fit(x, y, maxcomp = 5L, alpha = seq(0.2, 0.8, 0.2),
  reptimes = 500L, method = c("mc", "boot"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response vector.}

\item{maxcomp}{Maximum number of components included within each model.
If not specified, will use 5 by default.}

\item{alpha}{Parameter (grid) controlling sparsity of the model.
If not specified, default is \code{seq(0.2, 0.8, 0.2)}.}

\item{reptimes}{Number of models to build with Monte-Carlo resampling
or bootstrapping.}

\item{method}{Resampling method. \code{"mc"} (Monte-Carlo resampling)
or \code{"boot"} (bootstrapping). Default is \code{"mc"}.}

\item{ratio}{Sampling ratio used when \code{method = "mc"}.}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing all sparse partial least squares model objects.
}
\description{
Ensemble sparse partial least squares regression.
}
\examples{
data("logd1k")
x = logd1k$x
y = logd1k$y

set.seed(42)
fit = enspls.fit(x, y, reptimes = 4, maxcomp = 3)
print(fit)
predict(fit, newx = x)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.fs}} for measuring feature importance
with ensemble sparse partial least squares regressions.
See \code{\link{enspls.od}} for outlier detection with ensemble
sparse partial least squares regressions.
}

