#' @family texture
#' 
#' @title Hydrometer readings for a clay loam
#' 
#' @description
#' Data obtained with a 152H hydrometer in accordance with ASTM D422-63 (2007).
#' 
#' @format
#' A data frame containing 7 rows and 4 columns with information on:
#' 
#' \describe{
#'   \item{time}{the measurement time [min]}
#'   \item{temperature}{the temperature of the soil suspension [°C]}
#'   \item{reading}{the hydrometer reading at the bottom of the meniscus}
#'   \item{blank}{a blank value obtained in 5 g/L sodium hexametaphosphate
#'   solution (composite correction)}
#' }
#' 
#' @author 
#' ASTM International
#' 
#' @references
#' ASTM D422-63 (2007). \emph{Standard Test Method for Particle-Size Analysis
#' of Soils}. Technical standard. ASTM International, West Conshohocken, PA.
#' Available from \url{https://www.astm.org/standards/d422}.
#' 
#' @docType data
#' @keywords data
#' @name clayloam
NULL
