% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recplot2.R
\docType{class}
\name{enve.RecPlot2.Peak-class}
\alias{enve.RecPlot2.Peak-class}
\alias{enve.RecPlot2.Peak}
\title{Enveomics: Recruitment Plot (2) Peak - S4 Class}
\description{
Enve-omics representation of a peak in the sequencing depth histogram
of a Recruitment plot (see \code{\link{enve.recplot2.findPeaks}}).
}
\section{Slots}{

\describe{
\item{\code{dist}}{\code{(character)}
Distribution of the peak. Currently supported: \code{norm} (normal) and \code{sn}
(skew-normal).}

\item{\code{values}}{\code{(numeric)}
Sequencing depth values predicted to conform the peak.}

\item{\code{values.res}}{\code{(numeric)}
Sequencing depth values not explained by this or previously identified
peaks.}

\item{\code{mode}}{\code{(numeric)}
Seed-value of mode anchoring the peak.}

\item{\code{param.hat}}{\code{(list)}
Parameters of the distribution. A list of two values if dist=\code{norm} (sd
and mean), or three values if dist=\code{sn}(omega=scale, alpha=shape, and
xi=location). Note that the "dispersion" parameter is always first and
the "location" parameter is always last.}

\item{\code{n.hat}}{\code{(numeric)}
Number of bins estimated to be explained by this peak. This should
ideally be equal to the length of  \code{values}, but it's not an integer.}

\item{\code{n.total}}{\code{(numeric)}
Total number of bins from which the peak was extracted. I.e., total
number of position bins with non-zero sequencing depth in the recruitment
plot (regardless of peak count).}

\item{\code{err.res}}{\code{(numeric)}
Error left after adding the peak (mower) or log-likelihood (em or emauto).}

\item{\code{merge.logdist}}{\code{(numeric)}
Attempted \code{merge.logdist} parameter.}

\item{\code{seq.depth}}{\code{(numeric)}
Best estimate available for the sequencing depth of the peak (centrality).}

\item{\code{log}}{\code{(logical)}
Indicates if the estimation was performed in natural logarithm space.}
}}

\author{
Luis M. Rodriguez-R [aut, cre]
}
