% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcmsplus.R
\name{getbgremove}
\alias{getbgremove}
\title{Get the peak list with blank samples' peaks removed}
\usage{
getbgremove(xset, method = "medret", intensity = "into", file = NULL,
  rsdcf = 30, inscf = 1000)
}
\arguments{
\item{xset}{the xcmsset object with blank and certain group samples' data}

\item{method}{parameter for groupval function}

\item{intensity}{parameter for groupval function}

\item{file}{file name for further annotation, default NULL}

\item{rsdcf}{rsd cutoff for peaks, default 30}

\item{inscf}{intensity cutoff for peaks, default 1000}
}
\value{
diff report
}
\description{
Get the peak list with blank samples' peaks removed
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file("cdf", package = "faahKO")
xset <- getdata(cdfpath, pmethod = ' ')
getbgremove(xset)
}
}
