% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthCountByTemp.R
\name{monthCountByTemp}
\alias{monthCountByTemp}
\title{Month count by temperature}
\usage{
monthCountByTemp(tempStack, minTemp = 10)
}
\arguments{
\item{tempStack}{rasterStack of monthly mean temperature in degrees C * 10}

\item{minTemp}{reference temperature in degrees C}
}
\value{
rasterLayer with values representing counts of months.
}
\description{
Number of months with mean temperature greater than some base temp.
}
\examples{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# identify the appropriate layers
meantemp <- grep('mean', names(env), value=TRUE)
meantemp <- env[[meantemp]]
monthCountByTemp(meantemp, 10)
}
\author{
Pascal Title
}
\references{
Metzger, M.J., Bunce, R.G.H., Jongman, R.H.G., Sayre, R., Trabucco, A. & Zomer, R. (2013). 
A high-resolution bioclimate map of the world: a unifying framework for global 
biodiversity research and monitoring. \emph{Global Ecology and Biogeography}, 
\strong{22}, 630-638.
}

