% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlchart.R
\name{KRDetect.outliers.controlchart}
\alias{KRDetect.outliers.controlchart}
\title{Identification of outliers using control charts}
\usage{
KRDetect.outliers.controlchart(x, perform.smoothing = TRUE,
  bandwidth.type = "local", bandwidth.value = NULL, method = "range",
  group.size.x = 3, group.size.R = 3, group.size.s = 3, L.x = 3,
  L.R = 3, L.s = 3)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{perform.smoothing}{a logical value specifying if data smoothing is performed. If \code{TRUE} (default), data are smoothed.}

\item{bandwidth.type}{a character string specifying the type of bandwidth, must be \code{"local"} (default) or \code{"global"}.}

\item{bandwidth.value}{a local bandwidth array (for \code{bandwidth.type = "local"}) or global bandwidth value (for \code{bandwidth.type = "global"}) for kernel regression estimation. If \code{bandwidth.type = "NULL"} (default) a data-adaptive local plug-in (Herrmann, 1997) (for \code{bandwidth.type = "local"}) or data-adaptive global plug-in (Gasser et al., 1991) (for \code{bandwidth.type = "global"}) bandwidth is used instead.}

\item{method}{a character string specifying the preferred estimate of standard deviation parameter. Must be \code{"range"} (default) for estimate based on sample ranges or \code{"sd"} for estimate based on sample standard deviations. For more information see (Campulova et al., 2017).}

\item{group.size.x}{a positive integer giving the number of observations in individual segments used for computation of \emph{x} chart control limits.
If the data can not be equidistantly divided, the first extra values will be excluded from the analysis. Default is \code{group.size.x = 3}.}

\item{group.size.R}{a positive integer giving the number of observations in individual segments used for computation of \emph{R} chart control limits.
If the data can not be equidistantly divided, the first extra values will be excluded from the analysis. Default is \code{group.size.R = 3}.}

\item{group.size.s}{a positive integer giving the number of observations in individual segments used for computation of \emph{s} chart control limits.
If the data can not be equidistantly divided, the first extra values will be excluded from the analysis. Default is \code{group.size.s = 3}.}

\item{L.x}{a positive numeric value giving parameter \code{L} specifying the width of \emph{x} chart control limits. Default is \code{L.x = 3}.}

\item{L.R}{a positive numeric value giving parameter \code{L} specifying the width of \emph{R} chart control limits. Default is \code{L.R = 3}.}

\item{L.s}{a positive numeric value giving parameter \code{L} specifying the width of \emph{s} chart control limits. Default is \code{L.s = 3}.}
}
\value{
A list is returned with elements:
\item{method.type}{a character string giving the type of method used for outlier idetification}
\item{x}{a numeric vector of observations}
\item{index}{a numeric vector of index design points assigned to individual observations}
\item{smoothed}{a numeric vector of estimates of the kernel regression function (smoothed data)}
\item{outlier.x}{a logical vector specyfing the identified outliers based on limits of control chart \emph{x}, \code{TRUE} means that corresponding observation from vector \code{x} is detected as outlier}
\item{outlier.R}{a logical vector specyfing the identified outliers based on limits of control chart \emph{R}, \code{TRUE means} that corresponding observation from vector \code{x} is detected as outlier}
\item{outlier.s}{a logical vector specyfing the identified outliers based on limits of control chart \emph{s}, \code{TRUE means} that corresponding observation from vector \code{x} is detected as outlier}
\item{outlier}{a logical vector specyfing the identified outliers based on at least one type of control limits. \code{TRUE} means that corresponding observation from vector \code{x} is detected as outlier}
\item{LCL.x}{a numeric value giving lower control limit of control chart \emph{x}}
\item{UCL.x}{a numeric value giving upper control limit of control chart \emph{x}}
\item{LCL.s}{a numeric value giving lower control limit of control chart \emph{s}}
\item{UCL.s}{a numeric value giving upper control limit of control chart \emph{s}}
\item{LCL.R}{a numeric value giving lower control limit of control chart \emph{R}}
\item{UCL.R}{a numeric value giving upper control limit of control chart \emph{R}}
}
\description{
Identification of outliers in environmental data using two-step method based on kernel smoothing and control charts (Campulova et al., 2017).
The outliers are identified as observations corresponding to segments of smoothing residuals exceeding control charts limits.
}
\details{
This function identifies outliers in environmental data using two-step procedure (Campulova et al., 2017).
The procedure consists of kernel smoothing and subsequent identification of observations corresponding to segments of smoothing residuals exceeding control charts limits.
This way the method does not identify individual outliers but segments of observations, where the outliers occur.
The output of the method are three logical vectors specyfing the outliers identified based on each of the three control charts.
Beside that logical vector specyfing the outliers identified based on at least one type of control limits is returned.
Crucial for the method is the choice of paramaters \code{L.x}, \code{L.R} and \code{L.s} specifying the width of control limits.
Different values of the parameters determine different criteria for outlier detection. For more information see (Campulova et al., 2017).
}
\examples{
data("mydata", package = "openair")
x = mydata$o3[format(mydata$date, "\%m \%Y") == "12 2002"]
result = KRDetect.outliers.controlchart(x)
KRDetect.outliers.plot(result)
}
\references{
Campulova M, Veselik P, Michalek J (2017). Control chart and Six sigma based algorithms for identification of outliers in experimental data, with an application to particulate matter PM10. Atmospheric Pollution Research. Doi=10.1016/j.apr.2017.01.004.

Shewhart W (1931). Quality control chart. Bell System Technical Journal, 5, 593–603.

SAS/QC User's Guide, Version 8, 1999. SAS Institute, Cary, N.C.

Wild C, Seber G (2000). Chance encounters: A first course in data analysis and inference. New York: John Wiley.

Joglekar, Anand M. Statistical methods for six sigma: in R&D and manufacturing. Hoboken, NJ: Wiley-Interscience. ISBN sbn0-471-20342-4.

Gasser T, Kneip A, Kohler W (1991). A flexible and fast method for automatic smoothing. Journal of the American Statistical Association, 86, 643–652.

Herrmann E (1997). Local bandwidth choice in kernel regression estimation. Journal of Computational and Graphical Statistics, 6(1), 35–54.

Eva Herrmann; Packaged for R and enhanced by Martin Maechler (2016). lokern: Kernel Regression Smoothing with Local or Global Plug-in Bandwidth. R package version 1.1-8. https://CRAN.R-project.org/package=lokern
}
