% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptionsDataAPI.R
\name{get_options_data}
\alias{get_options_data}
\title{Get options data}
\usage{
get_options_data(
  api_token,
  ticker,
  date_to = NULL,
  date_from = NULL,
  trade_date_to = NULL,
  trade_date_from = NULL,
  contract_name = NULL
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{ticker}{Required - Could be any supported symbol. No default value.}

\item{date_to}{date from with format Y-m-d}

\item{date_from}{date from with format Y-m-d}

\item{trade_date_to}{date from with format Y-m-d}

\item{trade_date_from}{date from with format Y-m-d}

\item{contract_name}{Name of a particular contract.}
}
\value{
A list containing options data.
}
\description{
This function retrieves options data from the API.
}
\examples{
api_token <- "demo"
ticker <- "AAPL.US"
date_to <- "2017-09-10"
date_from <- "2017-09-12"
trade_date_to <- "2010-05-15"
trade_date_from <- "2010-05-16"
contract_name <- "AAPL230818C00055000"
result <- get_options_data(api_token, date_to, date_from, trade_date_to,
trade_date_from, contract_name)

}
