% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_samps.R
\name{get_samps}
\alias{get_samps}
\title{Retrieve final states from sampled Markov chains}
\usage{
get_samps(prefit, n)
}
\arguments{
\item{prefit}{An object of class \code{epimodel}. This object must have
been fit using \code{algorithm = "sampling"}.}

\item{n}{A positive integer. This specifies the number of states to sample.}
}
\value{
A list of length \eqn{n}. Each element in the list is itself a named
list, with elements corresponding to sample parameters. The result can be
passed directly as the \code{init} argument in \code{\link{epim}}.
}
\description{
\code{\link{get_samps}} can be used to randomly
select states from a fitted model object of class \code{epimodel}.
The object must have been fit using Markov chain Monte Carlo, i.e.
using \code{algorithm = "sampling"} in the call to \code{\link{epim}}.
The states are sampled uniformly at random without replacement, across
all chains and not including the warmup period.
}
\details{
This function can be used to specify the initial state for
sampling based on states from another sampling run. This
is particularly useful, for example, when you wish to fit a model using
\code{pop_adjust = T}, as this makes the posterior geometry difficult to
explore. Using a "prefit" run with \code{pop_adjust = F} is useful for
finding good states that can be used as initial states for the run with
the population adjustment.
}
