% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.epiflows.R
\name{plot.epiflows}
\alias{plot.epiflows}
\title{Various plots for epiflows objects}
\usage{
\method{plot}{epiflows}(x, type = c("map", "network", "grid"), ...)
}
\arguments{
\item{x}{an epiflows object.}

\item{type}{The type of plot to produce (defaults to map).}

\item{...}{arguments passed on to a given type}
}
\description{
The \code{plot} method for \code{epiflows} objects offers types of
graphics (argument \code{type}):
}
\details{
\itemize{
\item \code{map}: flows are displayed on an interactive map; see \link{map_epiflows} for
more details
\item \code{network}: flows are displayed as a network using the htmlwidget
\code{visNetwork} and the plotting method for \code{epicontacts} objects; see
\link{vis_epiflows} for more details
\item \code{grid}: flows are displayed as a grid between origins and destinations;
see \link{grid_epiflows} for more details
}
}
\examples{
data("Brazil_epiflows")

# no coordinates, defaults to network
plot(Brazil_epiflows) 

# grid bubbleplot
plot(Brazil_epiflows, "grid")

# adding coordinates defaults to map
data("YF_coordinates")
ef <- add_coordinates(Brazil_epiflows, YF_coordinates[-1])
plot(ef)
}
\author{
Salla Toikkanen, Thibaut Jombart, Zhian Kamvar
}
