% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protein.R
\name{protein_in_pathway}
\alias{protein_in_pathway}
\title{For the list of proteins, returns their associated pathway data}
\usage{
protein_in_pathway(uniprot_id_list, mode = c("table", "raw"))
}
\arguments{
\item{uniprot_id_list}{A list of protein UniProt IDs}

\item{mode}{If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \verb{POST /protein/in-pathway}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#post-proteinin-pathway}{\verb{POST /protein/in-pathway}}
}
\examples{
protein_in_pathway(uniprot_id_list = c("014933", "060674", "P32455"))
}
