% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getAlleleFreqRun}
\alias{getAlleleFreqRun}
\title{Get allele frequencies.}
\usage{
getAlleleFreqRun(pop)
}
\arguments{
\item{pop}{a \code{Population} object as returned by a previous
simulation run.}
}
\value{
Returns a matrix of allele frequencies, one generation per
row.
}
\description{
Get allele frequencies across a simulation run.
}
\details{
Retrieves the allele frequencies in each generation across a
simulation run.
}
\examples{
\donttest{
# Construct a population with additive and epistatic effects
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.9, narrowh2 = 0.6, traitVar = 40
)
pop <- addEffects(pop)
pop <- attachEpiNet(pop)

# Run the simulator
pop2 <- runSim(pop, generations = 150)

af <- getAlleleFreqRun(pop2)
}
}
\seealso{
\code{\link{runSim}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
