% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dist_params.R
\name{.calc_dist_params}
\alias{.calc_dist_params}
\title{Calculate the parameters of a probability distribution from a list of
summary statistics}
\usage{
.calc_dist_params(prob_distribution, summary_stats, sample_size)
}
\arguments{
\item{prob_distribution}{An S3 class containing the probability
distribution or a character string if the parameters of the probability
distribution are unknown but the name of the distribution is known, or \code{NA}
if the distribution name and parameters are unknown. Use
\code{\link[=create_prob_distribution]{create_prob_distribution()}} to create \code{prob_distribution}.}

\item{summary_stats}{A list of summary statistics, use
\code{\link[=create_summary_stats]{create_summary_stats()}} to create list. This list can include
summary statistics about the inferred distribution such as it's mean and
standard deviation, quantiles of the distribution, or information about the
data used to fit the distribution such as lower and upper range. The summary
statistics can also include uncertainty around metrics such as confidence
interval around mean and standard deviation.}

\item{sample_size}{The sample size of the data. Only needed when falling back
on using the median-range extraction calculation.}
}
\value{
A named \code{numeric} vector with parameters.
}
\description{
If parameters of a probability distribution are not
provided (e.g. when describing the distribution in the literature) and
instead summary statistics of a distribution are provided, the parameters
can usually be calculated from the summary statistics.

This function can provide a convenient wrapper around
\code{\link[=convert_summary_stats_to_params]{convert_summary_stats_to_params()}} and \code{\link[=extract_param]{extract_param()}}
when it is not known which summary statistics can be used to
calculate the parameters of a distribution.
}
\details{
The hierarchy of methods is:
\enumerate{
\item Conversion is prioritised if the mean and standard deviation are
available as these are mostly analytical conversions (except for one of the
Weibull conversions).
\item Next method if possible is extraction from percentiles. This method
requires a lower percentile (between(0-50]) and an upper percentile
(between (50-100)). If multiple percentiles in each of these ranges is
provided the lowest value is used for the calculation.
\item The last method is the extraction using a median and range of the data.
}
}
\keyword{internal}
