% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tomato_tswv}
\alias{tomato_tswv}
\title{Incidence of tomato spotted wilt virus (TSWV) disease in field trials.}
\format{There are two data frames:

\code{field_1928}: A data frame with 11088 rows and 8 variables:
\tabular{rll}{
    [, 1]   \tab plot       \tab Plot id. \cr
    [, 2]   \tab variety    \tab Variety name. \cr
    [, 3]   \tab irrigation \tab Irrigation system. \cr
    [, 4:5] \tab x,y        \tab Grid spatial coordinates. \cr
    [, 6]   \tab t          \tab Date of disease assessments. 1: 6 Nov, 2: 14
                                 Nov, 3: 21 Nov, 4: 28-29 Nov, 5: 5 Dec, 6:
                                 12 Dec 1928. \cr
    [, 7]   \tab i          \tab Disease incidence. 0: Healthy, 1: Diseased. \cr
    [, 8]   \tab n          \tab Sampling unit size. n = 1 means that the
                                 sampling unit size is the plant. \cr
}

\code{field_1929}: A data frame with 4320 rows and 5 variables:
\tabular{rll}{
    [, 1:2] \tab x,y \tab Grid spatial coordinates. \cr
    [, 3]   \tab t   \tab Date of disease assessments. 1: 18 Dec, 2: 31 Dec
                          1929, 3: 22 Jan 1930. \cr
    [, 4]   \tab i   \tab Disease incidence. 0: Healthy, 1: Diseased. \cr
    [, 5]   \tab n   \tab Sampling unit size. n = 1 means that the sampling
                          unit size is the plant. \cr
}}
\source{
Cochran WG. 1936. The statistical analysis of field counts of
    diseased plants. Supplement to the Journal of the Royal Statistical
    Society 3, 49–67. \href{http://dx.doi.org/10.2307/2983677}{doi:10.2307/2983677}

Bald JG. 1937. Investigations on "spotted wilt" of tomatoes. III.
    Infection in field plots. Bulletin 106. Melbourne, Australia: Council for
    Scientific and Industrial Research.
}
\usage{
tomato_tswv
}
\description{
Intensively mapped TSWV incidence data reported by Cochran (1936) and Bald
(1937). The disease assessments were performed in field trials at the Waite
Institute (Australia) in 1928 and 1929. TSWV is a virus disease spread by
thrips.
}
\details{
The data set \code{field_1928}, reported by Bald (1937), was a set of four
plots. Each plot consisted of 14 rows containing 33 plants each, so that
there were 462 plants in each plot. The tomato variety Early Dwarf Red was
used in two plots, and the variety Burwood Prize in the other two. The
tomatoes were planted out on 15th October 1928. The two plots dedicated to a
given variety experienced different irrigation practices, using either
overhead sprays or trenches. Otherwise, all were treated alike. Weekly
records of TSWV incidence were performed from 6th November to 12th December.

The data set \code{field_1929}, reported by Cochran (1936), was a field of 24
rows containing 60 plants each, so that there were 1440 plants. The tomatoes
were planted out in 26th November 1929. TSWV incidence records made on 18th
December 1929, 31st December 1929 and 22nd January 1930 are reported in this
data set.
}
\keyword{datasets}
