% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R
\name{selection}
\alias{selection}
\title{Sensitivity analysis to correct for selection bias.}
\usage{
selection(case, exposed, selprob = NULL, bias_parms = NULL, alpha = 0.05)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated
against.}

\item{exposed}{Exposure variable.}

\item{selprob}{Deprecated, please use bias_parms instead.}

\item{bias_parms}{Numeric vector defining the selection probabilities. This vector has 4 elements between 0 and 1, in the following order:
\enumerate{
\item Selection probability among cases exposed,
\item Selection probability among cases unexposed,
\item Selection probabillity among noncases exposed, and
\item Selection probability among noncases unexposed.
}}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analysed 2 x 2 table from the observed data.}
\item{corr.data}{The same table corrected for  selection proportions.}
\item{obs.measures}{A table of odds ratios and relative risk with confidence intervals.}
\item{adj.measures}{Selection bias corrected measures of outcome-exposure relationship.}
\item{bias.parms}{Input bias parameters: selection probabilities.}
\item{selbias.or}{Selection bias odds ratio based on the bias parameters chosen.}
}
\description{
Simple sensitivity analysis to correct for selection bias using estimates of
the selection proportions.
}
\examples{
# The data for this example come from:
# Stang A., Schmidt-Pokrzywniak A., Lehnert M., Parkin D.M., Ferlay J., Bornfeld N.
# et al.
# Population-based incidence estimates of uveal melanoma in Germany. Supplementing
# cancer registry data by case-control data.
# Eur J Cancer Prev 2006;15:165-70.
selection(matrix(c(136, 107, 297, 165),
dimnames = list(c("UM+", "UM-"), c("Mobile+", "Mobile-")),
nrow = 2, byrow = TRUE),
bias_parms = c(.94, .85, .64, .25))
}

