% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.episensr.probsens.R
\name{plot.episensr.probsens}
\alias{plot.episensr.probsens}
\title{Plot(s) of probabilistic bias analyses}
\usage{
\method{plot}{episensr.probsens}(
  x,
  parms = c("rr", "or", "rr_tot", "or_tot", "irr", "irr_tot", "seca", "seexp", "spca",
    "spexp", "or_sel", "prev.exp", "prev.nexp", "risk"),
  ...
)
}
\arguments{
\item{x}{An object of class "episensr.probsens" returned from the
\code{episensr probsens}, \code{probsens.sel}, \code{probsens.conf}, \code{probsens.irr},
\code{probsens.irr.conf} functions.}

\item{parms}{Choice between adjusted relative risk (\code{rr}) and odds ratio (\code{or}),
total error relative risk and odds ratio (\code{rr_tot} and \code{or_tot}), \code{seca},
\code{seexp}, \code{spca}, \code{or_sel}, and \code{spexp}, \code{prev.exp},
\code{prev.nexp} and \code{risk}, \code{irr} and \code{irr_tot}.}

\item{...}{Other unused arguments.}
}
\description{
This takes a \code{probsens}-family object and produces the distribution plot of
chosen bias parameters, as well as distribution of adjusted measures (with confidence
interval).
}
\examples{
set.seed(123)
plot(probsens(matrix(c(45, 94, 257, 945),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 20000,
seca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
spca.parms = list("trapezoidal", c(.75, .85, .95, 1))), "rr")

set.seed(123)
plot(probsens(matrix(c(45, 94, 257, 945),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 20000,
seca.parms = list("beta", c(908, 16)),
seexp.parms = list("beta", c(156, 56)),
spca.parms = list("beta", c(153, 6)),
spexp.parms = list("beta", c(205, 18)),
corr.se = .8,
corr.sp = .8), "seca")

set.seed(123)
plot(probsens.sel(matrix(c(136, 107, 297, 165),
dimnames = list(c("Melanoma+", "Melanoma-"), c("Mobile+", "Mobile-")),
nrow = 2, byrow = TRUE),
reps = 20000,
or.parms = list("triangular", c(.35, 1.1, .43))), "or_sel")

set.seed(123)
plot(probsens.conf(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")), nrow = 2, byrow = TRUE),
reps = 20000,
prev.exp = list("triangular", c(.7, .9, .8)),
prev.nexp = list("trapezoidal", c(.03, .04, .05, .06)),
risk = list("triangular", c(.6, .7, .63)),
corr.p = .8), "prev.exp")

set.seed(123)
plot(probsens.irr(matrix(c(2, 67232, 58, 10539000),
dimnames = list(c("GBS+", "Person-time"), c("HPV+", "HPV-")), ncol = 2),
reps = 20000,
seca.parms = list("trapezoidal", c(.4, .45, .55, .6)),
spca.parms = list("constant", 1)), "irr")

set.seed(123)
plot(probsens.irr.conf(matrix(c(77, 10000, 87, 10000),
dimnames = list(c("D+", "Person-time"), c("E+", "E-")), ncol = 2),
reps = 20000,
prev.exp = list("trapezoidal", c(.01, .2, .3, .51)),
prev.nexp = list("trapezoidal", c(.09, .27, .35, .59)),
risk = list("trapezoidal", c(2, 2.5, 3.5, 4.5)),
corr.p = .8), "risk")
}
\seealso{
\code{\link{probsens}, \link{probsens.sel}, \link{probsens.conf},
\link{probsens.irr}, \link{probsens.irr.conf}}
}
