% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataviz.R
\name{create_topchart}
\alias{create_topchart}
\title{Plot the top elements for a specific series on the epitweetr dashboard}
\usage{
create_topchart(
  topic,
  serie,
  country_codes = c(),
  date_min = "1900-01-01",
  date_max = "2100-01-01",
  with_retweets = FALSE,
  location_type = "tweet",
  top = 25
)
}
\arguments{
\item{topic}{Character(1) containing the topic to use for the report}

\item{serie}{Character(1) name of the series to be used for the report. It should be one of ("topwords", "hashtags", "entities", "contexts", "urls")}

\item{country_codes}{Character vector containing the ISO 3166-1 alpha-2 countries to plot, default: c()}

\item{date_min}{Date indicating start of the reporting period, default: "1900-01-01"}

\item{date_max}{Date indicating end of the reporting period, default: "2100-01-01"}

\item{with_retweets}{Logical value indicating whether to include retweets in the time series, default: FALSE}

\item{location_type}{Character(1) this parameter is currently being IGNORED since this report shows only tweet location and cannot show user or both locations for performance reasons, default: 'tweet'}

\item{top}{numeric(1) Parameter indicating the number of words to show, default: 25}
}
\value{
A named list containing two elements: 'chart' with the ggplot2 figure and 'data' containing the data frame that was used to build the map.
}
\description{
Generates a bar plot of most popular elements in tweets, for one topic. Top elements among ("topwords", "hashtags", "entities", "contexts", "urls")
}
\details{
Produces a bar chart showing the occurrences of the most popular words in the collected tweets based on the provided parameters.
For performance reasons on tweet aggregation, this report only shows tweet location and ignores the location_type parameter

This report may be empty for combinations of countries and topics with very few tweets since for performance reasons, the calculation of top words is an approximation using chunks of 10.000 tweets.

This functions requires that \code{\link{search_loop}} and \code{\link{detect_loop}} have already been run successfully to show results.
}
\examples{
if(FALSE){
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   #Getting topword chart for dengue for France, Chile, Australia for last 30 days
   create_topchart(
     topic = "dengue", 
     serie = "topwords", 
     country_codes = c("FR", "CL", "AU"),
     date_min = as.Date(Sys.time())-30, 
     date_max=as.Date(Sys.time())
   ) 
 }
}
\seealso{
\code{\link{trend_line}}
 \code{\link{create_map}}
 \code{\link{detect_loop}}
 \code{\link{search_loop}}
}
